module tutorial5
(
	input CLOCK_50,													// input Clock at 50MHz
	input [9:0] SW,													// switches to set the Key and Reset
	input [3:0] KEY,													// buttons to input the key sequence
	output [0:0] LEDR,
	output logic [6:0] HEX0, HEX1, HEX2, HEX3, HEX4, HEX5	// display the words OPEN and CLOSE
);

	logic [3:0] nKEY;
	logic tick;
	
	assign nKEY = ~KEY;				// inverts the push buttons logic to high active

	// User defined data type for the state machine (state FourCorrect could be Unlocked)
	// Add your code here
	
	
	// instantiantion of two eState variables to hold the current and next states
	// Add your code here
	
	
	
	// Slow frequency clock (inputs are 50MHz CLOCK_50 signal and reset, output is tick signal)
	slowClock #(26) U0(.Clock(CLOCK_50), .Reset(SW[9]), .Pulse(tick));
	
	
	
	// state register
	// Complete the code for the always_ff block
	always_ff @(posedge tick)	// This FF is enabled at slow frequency using 'tick' instead of 'CLOCK_50'
	begin
		// Add your code here
	end


	
	// state transition logic
	// Complete the code for the always_comb block
	always_comb
	begin
		if( SW[9] )
			nextState = Start;
		else
			begin
			// Add your code here to determine the next state of the FSM
			
			end
	end


	
	// Output logic
	// Complete the code for the always_comb block
	always_comb
	begin
		case (currentState)
			// Display Open
			FourCorrect:
			begin
				HEX5 = 7'b1000000;
				HEX4 = 7'b0001100;
				HEX3 = 7'b0000110;
				HEX2 = 7'b0101011;
				HEX1 = 7'b1111111;
				HEX0 = 7'b1111111;
			end
			
			// Otherwise display Closed
			// Add the code here to display 'Closed' in the 7-segment displays

		endcase;
	end

endmodule
